//
//  OPItemSetForURL.h
//  OnePasswordOSX
//
//  Created by Jeffrey Shiner on 1/21/2014.
//  Copyright (c) 2014 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPProfile.h"

@interface OPItemSetForURL : NSObject

@property (nonatomic, readonly) NSString *URLString;

@property (nonatomic, strong) OPProfile *profile;
@property (nonatomic, strong) NSSet *derivedLogins;
@property (nonatomic, strong) NSSet *nakedLogins;
@property (nonatomic, strong) NSSet *derivedPasswords;
@property (nonatomic, strong) NSSet *nakedPasswords;

@property (nonatomic, assign) BOOL quickFillMode;
@property (nonatomic, assign) BOOL limitMatchesToDerivedDomain;
@property (nonatomic, assign) BOOL limitMatchesToRegularScope;

@property (nonatomic, readonly) NSUInteger topLevelToDisplay;
@property (nonatomic, readonly) NSArray *matchingItems;

- (id)initWithURLString:(NSString *)URLString;

@end
